<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_latest
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
defined('_JEXEC') or die;

if (!$list)
{
	return;
}

?>
<section class="related-projects pb-90">
<div class="container">
	<h4 class="heading-inline"><?php echo $module->title;?></h4>
	<div class="customNavigation right">
		<a class="btn prev"><i class="fa fa-angle-left"></i></a>
		<a class="btn next"><i class="fa fa-angle-right"></i></a>
	</div>
	<div class="row mt-20">					

		<div id="owl-related-works" class="owl-carousel owl-theme">
			<?php foreach ($list as $item) :  ?> 
			<?php 
				$bt_image_intro = json_decode( $item->images)->image_intro;
				$bt_image_fulltext = json_decode( $item->images)->image_fulltext;
			?>
				<div class=" work-item  ">
					<div class="work-container">
						<div class="work-img">
							<img src="<?php echo URI::root().$bt_image_intro;?>" alt="<?php echo $item->title; ?>">
							<div class="portfolio-overlay">
								<div class="project-icons">
									<a href="<?php echo URI::root().$bt_image_fulltext;?>" class="lightbox-gallery" title="<?php echo $item->title; ?>"><i class="fa fa-search"></i></a>
									<a href="<?php echo $item->link; ?>" class="project-icon"><i class="fa fa-link"></i></a>
								</div>
							</div>
						</div>
						<div class="work-description">
							<h3><a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h3>
							<div></div>
						</div>
					</div> 
				</div> <!-- end work-item -->
				 
			<?php endforeach; ?>
		</div>
	</div>
</div>
</section>
