<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2009 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\AssociationHelper;
use Joomla\Component\Content\Site\Helper\RouteHelper;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('com_content.articles-list');

// Create some shortcuts.
$n          = count($this->items);
$listOrder  = $this->escape($this->state->get('list.ordering'));
$listDirn   = $this->escape($this->state->get('list.direction'));
$langFilter = false;

// Tags filtering based on language filter
if (($this->params->get('filter_field') === 'tag') && (Multilanguage::isEnabled()))
{
	$tagfilter = ComponentHelper::getParams('com_tags')->get('tag_list_language_filter');

	switch ($tagfilter)
	{
		case 'current_language':
			$langFilter = Factory::getApplication()->getLanguage()->getTag();
			break;

		case 'all':
			$langFilter = false;
			break;

		default:
			$langFilter = $tagfilter;
	}
}

// Check for at least one editable article
$isEditable = false;

if (!empty($this->items))
{
	foreach ($this->items as $article)
	{
		if ($article->params->get('access-edit'))
		{
			$isEditable = true;
			break;
		}
	}
} 
$currentDate = Factory::getDate()->format('Y-m-d H:i:s');
?> 
<div class="studies-area studies-area2 section-padding">
	<div class="container">
	  

	<?php if (empty($this->items)) : ?>
		<div class="alert alert-info">
			<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
				<?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?>
		</div>
	<?php else : ?>
		<div class="row grid"> 
			<?php foreach ($this->items as $i => $item) : ?>
			 
			<?php 				
				$bt_image_intro = json_decode( $item->images)->image_intro;
				$bt_image_fulltext = json_decode( $item->images)->image_fulltext;
			?>
			
				<div class="col-lg-4 col-md-6 col-sm-6 grid-item  ">
					<div class="studies-item">
                        <div class="studies-single">
                            <img src="<?php echo $bt_image_intro;?>" alt="">
                        </div>
                        <div class="overlay-text">
                            <div class="text-inner">
                                 
                                <h3><a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language));?>"><?php echo $item->title;?></a></h3>
                            </div>
                        </div>  
                    </div> 
				</div>
				 
				  
					<?php if ($this->params->get('show_category_introtext', 1)) : ?> 
					<?php echo $item->introtext; ?>
					<?php endif; ?> 
			
				  
			<?php endforeach; ?> 
		</div>
	<?php endif; ?>
	</div>
	<?php // Code to add a link to submit an article. ?>
	<?php if ($this->category->getParams()->get('access-create')) : ?>
		<?php echo HTMLHelper::_('contenticon.create', $this->category, $this->category->params); ?>
	<?php endif; ?>

	<?php // Add pagination links ?>
	<?php if (!empty($this->items)) : ?>
		<?php if (($this->params->def('show_pagination', 2) == 1  || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
			<div class="com-content-category__navigation col-md-12 text-center"> 
				<?php if ($this->params->def('show_pagination_results', 1)) : ?>
					<p class="com-content-category__counter counter float-end pt-3 pe-2 text-center">
						<?php echo $this->pagination->getPagesCounter(); ?>
					</p>
				<?php endif; ?>
				<div class="com-content-category__pagination  clear text-center">
					<?php echo $this->pagination->getPagesLinks(); ?>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>
	 
		 	
</div> 
