<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_bluecontact
 *
 * @copyright   Copyright (C) 2012 - 2020  , Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

//no direct access
defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Mail\Exception\MailDisabledException;
use Joomla\CMS\Mail\MailTemplate;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper; 
use Joomla\CMS\Layout\LayoutHelper; 
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\String\PunycodeHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
use Joomla\CMS\Versioning\VersionableControllerTrait;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\Utilities\ArrayHelper;
use PHPMailer\PHPMailer\Exception as phpMailerException;
PluginHelper::importPlugin('content'); 
$module->content = HTMLHelper::_('content.prepare', $module->content, '', 'mod_bluecontact.content');    
// Path assignments
$jebase = URI::base();
if (substr($jebase, -1) == "/") {
    $jebase = substr($jebase, 0, -1);
}
$modURL = URI::base() . 'modules/mod_bluecontact';

// params
$jQuery = $params->get("jQuery");
$popUp = $params->get("popUp", "0");
$popUpButton = $params->get("popUpButton", "Quick Contact");

$name = $params->get("name", "Name");
$email = $params->get("email", "Email");
$message = $params->get("message", "Message");
$captcha_label = $params->get("captcha_label", "1");
$captcha = $params->get("captcha", "Captcha");
$submit = $params->get("submit", "Send");

$subject = $params->get("subject", "");
$recipient = $params->get("recipient", "");

$buttonBg = $params->get('buttonBg', '#E60000');
$buttonText = $params->get('buttonText', '#ffffff');
$buttonBgH = $params->get('buttonBgH', '#333333');

$label_text = $params->get("label_text", "#333333");
$input_bg = $params->get("input_bg", "#ffffff");
$input_brd = $params->get("input_brd", "#cccccc");
$input_text = $params->get("input_text", "#333333");

// write to header
$app = Factory::getApplication();
$template = $app->getTemplate();
$doc = Factory::getDocument(); //only include if not already included
$doc->addStyleSheet($modURL . '/css/style.css');
$doc->addStyleSheet($modURL . '/css/modal.css');
$style = '
#je_contact button[type="submit"], .qcbutton a.je_button{ background:' . $buttonBg . '; color:' . $buttonText . ' ;}
#je_contact button[type="submit"]:hover, .qcbutton a.je_button:hover{ background:' . $buttonBgH . ' }
#je_contact input, #je_contact textarea{background-color:' . $input_bg . '; border:1px solid ' . $input_brd . '; color:' . $input_text . '}
';
$doc->addStyleDeclaration($style);
if ($params->get('jQuery')) {
    $doc->addScript('http://code.jquery.com/jquery-latest.pack.js');
}

$doc->addScript($modURL . '/js/modernizr.js');

$js = '';
$doc->addScriptDeclaration($js);

if (!isset($_SESSION)) {
    session_start();
}

if (isset($_POST['submitted'])) {
    // require a name from user
    if (trim($_POST['je_name']) === '') {
        $nameError = Text::_('MOD_BLUECONTACT_PLEASE_ENTER_YOUR_NAME');
        $hasError = true;
    } else {
        $name = trim($_POST['je_name']);
    }
    // need valid email
    if (trim($_POST['je_email']) === '') {
        $emailError = Text::_('MOD_BLUECONTACT_PLEASE_ENTER_YOUR_EMAIL');
        $hasError = true;
    } else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['je_email']))) {
        $emailError = 'You entered an invalid email address.';
        $hasError = true;
    } else {
        $email = trim($_POST['je_email']);
    }
    // we need at least some content
    if (trim($_POST['je_message']) === '') {
        $messageError = Text::_('MOD_BLUECONTACT_PLEASE_ENTER_YOUR_MESSAGE');
        $hasError = true;
    } else {
        if (function_exists('stripslashes')) {
            $message = stripslashes(trim($_POST['je_message']));
        } else {
            $message = trim($_POST['je_message']);
        }
    }

    // require a valid captcha
    if ($captcha_label == "1") {
        if (trim($_POST['je_captcha']) != $_SESSION['expect']) {
            $captchaError = Text::_('MOD_BLUECONTACT_PLEASE_ENTER_CORRECT_CAPTCHA');
            $hasError = true;
        } else {
            unset ($_SESSION['n1']);
            unset ($_SESSION['n2']);
            unset ($_SESSION['expect']);
            $captcha = trim($_POST['je_captcha']);
        }
    }


    // upon no failure errors let's email now!
    if (!isset($hasError)) {
        $body = "Subject: " . $subject . "<br/>";
        $body .= "Name: " . $_POST['je_name'] . "<br/>";
        $body .= "Email: " . $_POST['je_email'] . "<br/><br/>";
        $body .= $_POST['je_message'] . "<br/>";
 
        
		$app = $this->app;

		$templateData = [
			'sitename' => $app->get('sitename'),
			'name'     => $_POST['je_name'],
			'contactname' => $_POST['je_name'],
			'email'    => PunycodeHelper::emailToPunycode($recipient),
			'subject'  => $subject,
			'body'     => stripslashes($body),
			'url'      => Uri::base(),
			'customfields' => ''
		];
		$mailer = new MailTemplate('com_contact.mail', $app->getLanguage()->getTag());
		$mailer->addRecipient($recipient);
		//$mailer->setReplyTo($templateData['email'], $templateData['name']);
		$mailer->addTemplateData($templateData);
		$sent = $mailer->send();
		$emailSent = true;		
        
    }
}
if ($captcha_label == "1") {
    $_SESSION['n1'] = rand(1, 15);
    $_SESSION['n2'] = rand(1, 15);
    $_SESSION['expect'] = $_SESSION['n1'] + $_SESSION['n2'];
}

require ModuleHelper::getLayoutPath('mod_bluecontact', $params->get('layout', 'default'));



