<?php
/**
 * @package     Joomla.Site
 * @subpackage  Templates.Consultar
 *
 * @copyright   (C) 2017 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

/** @var Joomla\CMS\Document\HtmlDocument $this */

$app = Factory::getApplication();
$wa  = $this->getWebAssetManager();

// Browsers support SVG favicons
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
$this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => '#000']);

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu     = $app->getMenu()->getActive();
$pageclass = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';

// Template path
$templatePath = 'templates/' . $this->template;
    
// Get params for active menu
$menu_params = $menu->getParams();
  
$bt_header = $this->params->get('bt_header',1); 
$bt_banner_bg = 0;	
if ( $menu_params->get('bt_banner',0)){
	
	$bt_banner_bg = $menu_params->get('bt_banner_bg'); 
} 	
if ($menu_params->get('bt_header',0) != 0){
	
	$bt_header = $menu_params->get('bt_header'); 
} 
$this->setMetaData('viewport', 'width=device-width, initial-scale=1');
$doc = Factory::getDocument();
$doc->addScript('https://code.jquery.com/jquery-latest.pack.js'); 
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
	<jdoc:include type="metas" />
	<jdoc:include type="styles" />
	<jdoc:include type="scripts" /> 
	<link href="<?php echo uri::root().$templatePath;?>/css/font-awesome.min.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/flaticon.css" rel="stylesheet">
    <!-- Bootstrap core CSS -->
    <link href="<?php echo uri::root().$templatePath;?>/css/bootstrap.min.css" rel="stylesheet">
    <!-- Plugins for this template -->
    <link href="<?php echo uri::root().$templatePath;?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/owl.carousel.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/odometer-theme-default.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/slick.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/slick-theme.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/slicknav.min.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/magnific-popup.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/jquery-isotope.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/metisMenu.min.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/jquery.fancybox.css" rel="stylesheet">
    <!-- Custom styles for this template -->
    <link href="<?php echo uri::root().$templatePath;?>/css/style.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/responsive.css" rel="stylesheet">
    <link href="<?php echo uri::root().$templatePath;?>/css/custom.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
	<!-- LESS stylesheet for managing color presets 
    <link rel="stylesheet/less" type="text/css" 
        href="<?php echo uri::root().$templatePath;?>/less/color.php?color_left=<?php echo  str_replace('#','',$bt_color_left); ?>&color_right=<?php echo  str_replace('#','',$bt_color_right); ?>">
	-->
    <!-- LESS JS engine   
    <script src="<?php echo uri::root().$templatePath;?>/less/less-1.5.0.min.js"></script>-->
</head>

<body   
	class="site <?php echo $option
	. ' view-' . $view
	. ($layout ? ' layout-' . $layout : ' no-layout')
	. ($task ? ' task-' . $task : ' no-task')
	. ($itemid ? ' itemid-' . $itemid : '')
	. ($pageclass ? ' ' . $pageclass : '')
	. ($this->direction == 'rtl' ? ' rtl' : '') ; ?>" > 
	<?php if ($this->params->get('preloader') == 1) : ?>
	<!-- preloader area start -->
    <div id="preloader">
        <div class="loader_line"></div>
    </div>
    <!-- prealoader area end -->
	<?php endif;?>
	<?php if ($bt_header == 1){ ?>
	<header>
        <div class="header-top">
            <div class="container">
                <div class="row">
                    <div class="col-md-9 col-sm-12 col-12 col-lg-10">
                        <jdoc:include type="modules" name="top-left" style="html" /> 
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-12">
                        <jdoc:include type="modules" name="top-right" style="html" /> 
                    </div>
                </div>
            </div>
        </div>
        <div class="header-area header-area2">
            <div class="header-shot" id="sticky-header">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-3 col-md-10 col-sm-10 col-8">
                            <div class="logo">
                                <a href="<?php echo URI::root();?>"><img src="<?php echo $this->params->get('logoFile');?>" alt="<?php echo $sitename;?>"></a>
                            </div>
                        </div>
                        <div class="col-lg-8 d-none d-lg-block">
                            <div class="main-menu">
                                <nav class="nav_mobile_menu">
                                    <jdoc:include type="modules" name="menu" style="none" />  
                                </nav>
                            </div>
                        </div>
                        <div class="col-lg-1 col-md-2 col-sm-2 col-4 search">
                            <jdoc:include type="modules" name="search" style="html" />
							
                        </div>
                        <div class="col-12 d-block d-lg-none">
                            <div class="mobile_menu"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
	<?php }elseif ($bt_header == 2){ ?>
	<header>
        <div class="header-top header-top-2">
            <div class="container">
                 <div class="row">
                    <div class="col-md-9 col-sm-12 col-12 col-lg-10">
                        <jdoc:include type="modules" name="top-left" style="html" /> 
						
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-12">
						<jdoc:include type="modules" name="top-right" style="html" /> 
                        
                    </div>
                </div>
            </div>
        </div>
        <div class="header-area" id="sticky-header">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-10 col-sm-10 col-8">
                        <div class="logo">
                            <a href="<?php echo URI::root();?>"><img src="<?php echo $this->params->get('logoFile');?>" alt="<?php echo $sitename;?>"></a>
                        </div>
                        </div>
                        <div class="col-lg-8 d-none d-lg-block">
                            <div class="main-menu" id="navbar">
								<nav class="nav_mobile_menu">
                                <jdoc:include type="modules" name="menu" style="none" />  
								</nav>
                            </div>
                        </div>
                        <div class="col-lg-1 col-md-2 col-sm-2 col-4 search">
                            <jdoc:include type="modules" name="search" style="html" />
							
                        </div>
                        <div class="col-12 d-block d-lg-none">
                            <div class="mobile_menu"></div>
                        </div>
                    </div>
                </div>
            </div>
    </header>
	<?php } ?>
	<?php if ($this->countModules('main-feature')): ?> 
	<jdoc:include type="modules" name="main-feature" style="noCard" />  
	<?php endif ;?>	  
	 
		<?php if ($this->countModules('breadcrumbs')) : ?>
		<div class="breadcumb-area" style="background: url(<?php echo URI::root().$bt_banner_bg;?>)  no-repeat center top/cover">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="breadcumb-wrap">
							<h2><?php echo $this->title;?></h2>
							<jdoc:include type="modules" name="breadcrumbs" style="none" />
						</div>
					</div>
				</div>
			</div>
		</div>
		 
		<?php endif;?> 
		
		<jdoc:include type="modules" name="main-top" style="card" />
		<?php if ($this->countModules('sidebar-right')){ ?>
			<div class="blog-page-area section-padding">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8 col-md-12 col-12">
						<jdoc:include type="message" />
						<div class="blog-left-bar">
						<jdoc:include type="component" />
						</div>
					</div>
					<!-- sidebar -->
					<div class="col-lg-4 col-md-12 col-12">
					<div class="blog-right-bar practice-details-area case-stadies-details-area">
                        <div class="row">
						<jdoc:include type="modules" name="sidebar-right" style="sidebar" /> 
						</div> 
					</div> 
					</div> 
				</div>
			</div>
			</div> 
		<?php }else{ ?> 
			<jdoc:include type="message" />
			<main>
			<jdoc:include type="component" />
			</main>
						 
		<?php } ?> 
		<jdoc:include type="modules" name="main-bottom" style="card" />
	 
 
	<!-- .footer-area start -->
    <div class="footer-area">
        <div class="footer-top">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6 col-sm-6">
                        <jdoc:include type="modules" name="footer1" style="footer" />
						
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6">
						<jdoc:include type="modules" name="footer2" style="footer" />
                         
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6">
						<jdoc:include type="modules" name="footer3" style="footer" />
                         
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6">
						<jdoc:include type="modules" name="footer4" style="footer" /> 
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="footer-bottom-content">
                    <div class="row">
                        <div class="col-lg-6 col-12">
							<jdoc:include type="modules" name="footer-copyright" style="footer" /> 
                            
                        </div>
                        <div class="col-lg-6 col-12">
							<jdoc:include type="modules" name="footer-socials" style="footer" /> 
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- .footer-area end -->
	   
	<script src="<?php echo uri::root().$templatePath;?>/js/bootstrap.min.js"></script>
    <!-- Plugins for this template -->
    <script src="<?php echo uri::root().$templatePath;?>/js/jquery-plugin-collection.js"></script>
    <script src="<?php echo uri::root().$templatePath;?>/js/jquery.slicknav.min.js"></script>
    <script src="<?php echo uri::root().$templatePath;?>/js/metisMenu.min.js"></script>
    <!-- Custom script for this template -->
    <script src="<?php echo uri::root().$templatePath;?>/js/script.js"></script>	
	<jdoc:include type="modules" name="debug" style="none" />
</body>
</html>
